function [figure_counter]= visuals(new_geo, Q, units, ...
    n_ranges, n_eco_func, matrix, firstCol, start_day, end_day,...
    eco_names, spaces, julian_day, figure_counter, n_chunks, ...
    eco_func_per_chunk, final_rows, func_choice, new_geo_p)
%Visualization of the inputs

choose_vis = 0;
vis_choice = 0;

while choose_vis == 0
    disp('<<<<    Visualizing the Inputs    >>>>')
    disp(' ')
    disp('Would you like to see any of your inputs graphically?')
    disp('1. Yes')
    disp('2. No')
    disp(' ')
    choose_vis = input('Please enter 1 or 2:  ');
    
    switch choose_vis
        
        case 1
            
            while vis_choice == 0
                disp(' ')
                disp('What inputs would you like to see?')
                disp(' ')
                disp('1.  The cross sectional geometry of the riffle (if available)')
                disp('2.  The cross sectional geometry of the pool (if available)')                
                disp('3.  The hydrograph')
                disp('4.  The functionality table')
                disp('5.  The graph of the ecological functions')
                disp('6.  I do not want to see anymore inputs.')
                disp('*** This menu will prompt again if choice 6 is not entered. ***')
                disp(' ')
                vis_choice = input('Please enter your choice, 1 through 6:  ');
                
                switch vis_choice
                    
                    %% Plotting the cross sectional geometry of the riffle
                    case 1  
                        
                        if new_geo == 0
                            
                            disp(' ')
                            disp('There is no cross sectional riffle geometry to display.')
                            disp(' ')
                            
                        else
                            
                            figure(figure_counter)
                            figure_counter = figure_counter +1;
                            plot(new_geo(:,1),new_geo(:,2))
                            title('Cross-sectional geometry of the riffle')
                            
                            if units == 1
                                xlabel('X distance (m)')
                                ylabel('Y distance (m)')                            
                            else
                                xlabel('X distance (ft)')
                                ylabel('Y distance (ft)')
                            end %of units if                            
                            
                        end %of if new_geo is equal zero
                        
                        vis_choice = 0;
                        
                    %% Plotting the pool's xs geometry    
                    case 2  
                        
                        if new_geo_p == 0
                            
                            disp(' ')
                            disp('There is no cross sectional pool geometry to display.')
                            disp(' ')
                            
                        else
                            
                            figure(figure_counter)
                            figure_counter = figure_counter +1;
                            plot(new_geo_p(:,1),new_geo_p(:,2))
                            title('Cross-sectional geometry of the pool')
                            
                            if units == 1
                                xlabel('X distance (m)')
                                ylabel('Y distance (m)')                            
                            else
                                xlabel('X distance (ft)')
                                ylabel('Y distance (ft)')
                            end %of units if                            
                            
                        end %of if new_geo_p is equal zero
                        
                        vis_choice = 0;
                        
                    %% Plotting the hydrograph    
                    case 3  
                        
                        figure(figure_counter)
                        figure_counter = figure_counter +1;
                        plot(julian_day,Q)
                        title('Hydrograph vs Julian Day')
                        xlabel('Julian Day')
                        if units == 1                            
                            ylabel('Q (m^3/s)')                            
                        else
                            ylabel('Q (ft^3/s)')
                        end
                        
                        vis_choice = 0;
                        
                    %% Displaying the functionality table
                    case 4
                        
                        for i = 1:70
                            spaces_vector(i) = [' '];
                        end
                        
                        %Outputs the correct message before the table
                        if func_choice == 1
                            disp(' ')
                            disp('This is the default compact functionality table you selected:')
                            disp(' ')
                        elseif func_choice == 2
                            disp(' ')
                            disp('This is the default full functionality table you selected:')
                            disp(' ')
                        elseif func_choice == 3
                            disp(' ')
                            disp('This is the custom functionality table you entered:')
                            disp(' ')
                        end
                        
                        for m = 1:n_chunks

                            if m > 1
                                disp('Functionality Table (continued)')
                            end

                            knuckle = find(char(final_rows(m,:)) ~= ' ');
                            middle_knuckle = floor((knuckle(end)-knuckle(1))/2);
                            titleRow = ['Tau',spaces_vector(1,1:(middle_knuckle-10 + knuckle(1) - 3)),'Ecological Functions'];
                            disp(titleRow)
                            disp(char(final_rows(m,:)))
                            for i=1:n_ranges
                                fprintf(firstCol(i,:))
                                for j=(1 + sum(eco_func_per_chunk(1:m-1))):sum(eco_func_per_chunk(1:m))
                                    for k=1:spaces(m)/2-1
                                        fprintf(' ')
                                    end
                                    fprintf(num2str(matrix(i,j)))
                                    for k=1:spaces(m)/2
                                        fprintf(' ')
                                    end
                                end
                                fprintf('\n')
                            end %i loop
                            disp(' ')
                            disp(' ')
                        end %m loop

                        vis_choice = 0;
                        
                    %% Plotting the graph of the duration of the ecological
                    % functions
                    case 5
                        
                        for i = 1:n_eco_func
                            
                            for j = 1:366      %length(julian_day)
                                
                                %% condition for starting day before ending
                                %% day
                                if start_day(i) < end_day(i)
                                    if j < start_day(i) | j >= end_day(i)  %julian_day(j) < start_day(i) | julian_day(j) >= end_day(i)
                                        days(j) = -1;  %0;
                                    else
                                        days(j) = i;
                                    end %inner if
                                end %outer if
                                
                                %% condition for a wrap around:  the
                                %% starting day is later than ending day
                                if start_day(i) > end_day(i)
                                    if j < end_day(i) | j >= start_day(i)  %julian_day(j) < end_day(i) | julian_day(j) >= start_day(i)
                                        days(j) = i;
                                    else
                                        days(j) = -1;   %0;
                                    end %inner if
                                end %outer if
                                
                            end %j
                            
                            holder = find(eco_names(i,:) ~= 32);
                            holder = eco_names(i,holder(1):holder(end));
                            
                            figure(figure_counter)                            
                            plot((1:1:366),days,'b.')
                            axis([0 366 0 (n_eco_func + 0.5)])
                            text(10,(i+0.2),char(holder))
                            hold on
                            title('Duration of Ecological Functions')
                            xlabel('Julian Day')
                            ylabel('Duration')                            
                            
                        end %i
                        
                        vis_choice = 0;
                        figure_counter = figure_counter +1;
                        
                    %% Returns.
                    case 6
                        
                        return
                        
                    otherwise
                        disp(' ')
                        disp('Please enter a number, 1 through 5.')
                        disp(' ')
                        vis_choice = 0;                        
                        
                end %switch
                
            end %while            
            
        case 2
            
            continue
            
        otherwise
            disp(' ')
            disp('Please enter either 1 or 2.')
            disp(' ')
            choose_vis = 0;
            
    end %switch
    
end %while